// $Id: CProgressBar.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CProgressBar.hpp"
using Exponent::GUI::Controls::CProgressBar;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CProgressBar, CTextLabel);

//	===========================================================================
CProgressBar::CProgressBar(IControlRoot *root, const long uniqueId, const CRect &area) 
			: CTextLabel(root, uniqueId, area, "0%")
			, m_progressBarArea(0, 0, 0, area.getHeight())
{
	EXPONENT_CLASS_CONSTRUCTION(CProgressBar);
	this->controlIsMouseEnabled(false);
	this->controlIsDropFileEnabled(false);
	this->setTextFormat(CGraphics::e_centerCenterAlign);
}

//	===========================================================================
CProgressBar::~CProgressBar()
{
	EXPONENT_CLASS_DESTRUCTION(CProgressBar);
}

//	===========================================================================
void CProgressBar::setValue(const double value)
{
	// Store the value
	CControl::setValue(value);

	// Now compute the box area
	m_progressBarArea.setWidth((long)((m_area.getWidth() - 4) * m_value));
	m_text.setStringWithFormat("%li%%", (long)(m_value * 100.0));

	// Redraw the window
	this->update();
}

//	===========================================================================
void CProgressBar::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the background
	this->drawPrimaryImage(graphics, m_doDefaultDrawing);

	// Draw the progress bar
	graphics.getMutablePen()->setColour(m_backgroundColour);
	graphics.drawGradientFilledRectangle(m_progressBarArea);

	// Draw the text string out
	graphics.setTextColour(m_textColour);
	graphics.drawText(m_text, CRect(1, 1, m_area.getWidth(), m_area.getHeight()), m_font, m_textFormat);
}